
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="x1", lb=0)  # milligrams of vitamin B5
    x2 = model.addVar(name="x2", lb=0)  # milligrams of zinc
    x3 = model.addVar(name="x3", lb=0)  # milligrams of vitamin B7
    x4 = model.addVar(name="x4", lb=0)  # milligrams of vitamin B4
    x5 = model.addVar(name="x5", lb=0)  # milligrams of calcium

    # Objective function
    model.setObjective(5.81*x1 + 4.93*x2 + 5.73*x3 + 8.21*x4 + 8.07*x5, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(5*x1 + 20*x2 + 31*x3 + 14*x4 + 31*x5 <= 601)
    model.addConstr(5*x1 + 20*x2 + 31*x3 >= 69)
    model.addConstr(5*x1 + 20*x2 + 14*x4 >= 69)
    model.addConstr(5*x1 + 20*x2 + 31*x3 >= 80)
    model.addConstr(5*x1 + 20*x2 + 14*x4 >= 80)
    model.addConstr(5*x1 + 31*x5 <= 486)
    model.addConstr(20*x2 + 31*x3 <= 213)
    model.addConstr(5*x1 + 20*x2 + 31*x3 + 14*x4 + 31*x5 <= 213)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B5: {x1.varValue}")
        print(f"Milligrams of zinc: {x2.varValue}")
        print(f"Milligrams of vitamin B7: {x3.varValue}")
        print(f"Milligrams of vitamin B4: {x4.varValue}")
        print(f"Milligrams of calcium: {x5.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
