
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="milligrams_of_potassium")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="milligrams_of_magnesium")


    # Set objective function
    m.setObjective(4*x0 + 5*x1, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(23*x0 + 14*x1 >= 39, "digestive_support_lower_bound")
    m.addConstr(24*x0 + 28*x1 >= 125, "cognitive_performance_lower_bound")
    m.addConstr(x0 - 8*x1 >= 0, "potassium_magnesium_ratio")
    m.addConstr(23*x0 + 14*x1 <= 58, "digestive_support_upper_bound")
    m.addConstr(24*x0 + 28*x1 <= 219, "cognitive_performance_upper_bound")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('milligrams_of_potassium:', x0.x)
        print('milligrams_of_magnesium:', x1.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

