
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_potassium")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_magnesium")

# Set objective function
m.setObjective(4*x0 + 5*x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(23*x0 + 14*x1 >= 39, "digestive_support_index")
m.addConstr(24*x0 + 28*x1 >= 125, "cognitive_performance_index_min")
m.addConstr(x0 - 8*x1 >= 0, "potassium_magnesium_constraint")
m.addConstr(23*x0 + 14*x1 <= 58, "digestive_support_index_max")
m.addConstr(24*x0 + 28*x1 <= 219, "cognitive_performance_index_max")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Potassium: {x0.x}")
    print(f"Milligrams of Magnesium: {x1.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
