
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='milligrams_of_potassium', lb=0)  # Assuming non-negative
    x2 = model.addVar(name='milligrams_of_magnesium', lb=0)  # Assuming non-negative

    # Define the objective function
    model.setObjective(4 * x1 + 5 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(23 * x1 + 14 * x2 >= 39, name='digestive_support_index_min')
    model.addConstr(24 * x1 + 28 * x2 >= 125, name='cognitive_performance_index_min')
    model.addConstr(x1 - 8 * x2 >= 0, name='potassium_magnesium_ratio')
    model.addConstr(23 * x1 + 14 * x2 <= 58, name='digestive_support_index_max')
    model.addConstr(24 * x1 + 28 * x2 <= 219, name='cognitive_performance_index_max')

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Optimal solution found.')
        print(f'Milligrams of potassium: {x1.varValue}')
        print(f'Milligrams of magnesium: {x2.varValue}')
        print(f'Objective function value: {model.objVal}')
    else:
        print('No optimal solution found.')

solve_optimization_problem()
