
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x0")  # hours worked by Paul
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x1")  # hours worked by Peggy
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x2")  # hours worked by Jean
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x3")  # hours worked by Dale

    # Objective function
    model.setObjective(2.91 * x0 + 4.55 * x1 + 2.66 * x2 + 5.97 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(9 * x0 <= 291)
    model.addConstr(10 * x0 <= 231)
    model.addConstr(7 * x0 <= 394)
    model.addConstr(8 * x1 <= 291)
    model.addConstr(26 * x1 <= 231)
    model.addConstr(24 * x1 <= 394)
    model.addConstr(27 * x2 <= 291)
    model.addConstr(31 * x2 <= 231)
    model.addConstr(29 * x2 <= 394)
    model.addConstr(11 * x3 <= 291)
    model.addConstr(9 * x3 <= 231)
    model.addConstr(29 * x3 <= 394)
    model.addConstr(8 * x1 + 11 * x3 >= 71)
    model.addConstr(9 * x0 + 11 * x3 >= 39)
    model.addConstr(9 * x0 + 8 * x1 >= 61)
    model.addConstr(9 * x0 + 27 * x2 + 11 * x3 >= 72)
    model.addConstr(9 * x0 + 29 * x2 + 11 * x3 >= 72)
    model.addConstr(8 * x1 + 27 * x2 + 11 * x3 >= 72)
    model.addConstr(9 * x0 + 27 * x2 + 11 * x3 >= 52)
    model.addConstr(9 * x0 + 29 * x2 + 11 * x3 >= 52)
    model.addConstr(8 * x1 + 29 * x2 + 11 * x3 >= 52)
    model.addConstr(9 * x0 + 8 * x1 + 27 * x2 >= 66)
    model.addConstr(9 * x0 + 29 * x2 + 11 * x3 >= 66)
    model.addConstr(8 * x1 + 27 * x2 + 11 * x3 >= 66)
    model.addConstr(9 * x0 + 8 * x1 + 27 * x2 + 11 * x3 >= 66)
    model.addConstr(26 * x1 + 31 * x2 >= 45)
    model.addConstr(26 * x1 + 9 * x3 >= 50)
    model.addConstr(26 * x1 + 31 * x2 + 9 * x3 >= 56)
    model.addConstr(10 * x0 + 26 * x1 + 31 * x2 + 9 * x3 >= 56)
    model.addConstr(7 * x0 + 24 * x1 >= 87)
    model.addConstr(29 * x2 + 29 * x3 >= 37)
    model.addConstr(7 * x0 + 29 * x2 >= 34)
    model.addConstr(7 * x0 + 29 * x3 >= 34)
    model.addConstr(7 * x0 + 24 * x1 + 29 * x2 + 29 * x3 >= 34)
    model.addConstr(4 * x0 - x1 >= 0)
    model.addConstr(9 * x0 + 8 * x1 <= 209)
    model.addConstr(8 * x1 + 11 * x3 <= 209)
    model.addConstr(8 * x1 + 27 * x2 <= 78)
    model.addConstr(9 * x0 + 27 * x2 <= 269)
    model.addConstr(9 * x0 + 11 * x3 <= 176)
    model.addConstr(9 * x0 + 8 * x1 + 11 * x3 <= 109)
    model.addConstr(9 * x0 + 27 * x2 + 11 * x3 <= 108)
    model.addConstr(10 * x0 + 31 * x2 <= 109)
    model.addConstr(26 * x1 + 9 * x3 <= 138)
    model.addConstr(10 * x0 + 31 * x2 + 9 * x3 <= 167)
    model.addConstr(26 * x1 + 31 * x2 + 9 * x3 <= 177)
    model.addConstr(10 * x0 + 26 * x1 + 31 * x2 <= 93)

    model.optimize()

    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print("Hours worked by Paul: ", x0.varValue)
        print("Hours worked by Peggy: ", x1.varValue)
        print("Hours worked by Jean: ", x2.varValue)
        print("Hours worked by Dale: ", x3.varValue)
        print("Objective function value: ", model.objVal)
    else:
        print("No optimal solution found.")

solve_optimization_problem()
