
import gurobi

def optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="peanutbutter_sandwiches", lb=0)
    x1 = model.addVar(name="oreos", lb=0)
    x2 = model.addVar(name="kiwis", lb=0)
    x3 = model.addVar(name="fruit_salads", lb=0)
    x4 = model.addVar(name="milkshakes", lb=0)
    x5 = model.addVar(name="eggs", lb=0)

    # Objective function
    model.setObjective(4.47*x0 + 7.12*x1 + 3.96*x2 + 7.26*x3 + 9.54*x4 + 7.14*x5, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(14*x0 + 4*x3 >= 12)
    model.addConstr(2*x2 + 2*x4 >= 15)
    model.addConstr(2*x2 + 4*x3 >= 9)
    model.addConstr(14*x0 + 2*x2 >= 8)
    model.addConstr(4*x3 + 11*x5 >= 6)
    model.addConstr(14*x0 + 2*x4 >= 5)
    model.addConstr(13*x1 + 4*x3 >= 5)
    model.addConstr(14*x0 + 11*x5 >= 14)
    model.addConstr(4*x3 + 2*x4 >= 6)
    model.addConstr(13*x1 + 2*x4 >= 15)
    model.addConstr(13*x1 + 2*x4 + 11*x5 >= 15)
    model.addConstr(14*x0 + 13*x1 + 2*x2 + 4*x3 + 2*x4 + 11*x5 >= 15)
    model.addConstr(14*x2 + 6*x3 + 13*x4 >= 50)
    model.addConstr(6*x3 + 14*x5 >= 49)
    model.addConstr(11*x0 + 6*x3 >= 57)
    model.addConstr(14*x2 + 6*x3 >= 21)
    model.addConstr(13*x4 + 14*x5 >= 48)
    model.addConstr(5*x1 + 14*x5 >= 39)
    model.addConstr(5*x1 + 13*x4 >= 25)
    model.addConstr(5*x1 + 14*x2 >= 43)
    model.addConstr(14*x2 + 14*x5 >= 32)
    model.addConstr(11*x0 + 5*x1 + 14*x2 + 6*x3 + 13*x4 + 14*x5 >= 37)
    model.addConstr(2*x1 - 4*x3 >= 0)
    model.addConstr(13*x1 + 2*x2 + 4*x3 <= 88)
    model.addConstr(2*x2 + 2*x4 + 11*x5 <= 33)
    model.addConstr(13*x1 + 4*x3 + 2*x4 <= 53)
    model.addConstr(2*x2 + 4*x3 + 2*x4 <= 29)
    model.addConstr(13*x1 + 2*x4 + 11*x5 <= 79)
    model.addConstr(4*x3 + 2*x4 + 11*x5 <= 97)
    model.addConstr(14*x0 + 4*x3 + 2*x4 <= 43)
    model.addConstr(13*x1 + 2*x2 + 2*x4 <= 25)
    model.addConstr(14*x0 + 13*x1 + 2*x2 <= 99)
    model.addConstr(14*x0 + 13*x1 + 2*x4 <= 51)
    model.addConstr(2*x2 + 4*x3 + 11*x5 <= 44)
    model.addConstr(13*x1 + 2*x2 + 11*x5 <= 35)
    model.addConstr(13*x1 + 4*x3 + 11*x5 <= 82)
    model.addConstr(5*x1 + 13*x4 <= 369)
    model.addConstr(11*x0 + 14*x2 + 13*x4 <= 386)
    model.addConstr(11*x0 + 13*x4 + 14*x5 <= 371)
    model.addConstr(11*x0 + 5*x1 + 14*x2 <= 258)
    model.addConstr(14*x2 + 6*x3 + 13*x4 <= 276)
    model.addConstr(11*x0 + 6*x3 + 13*x4 <= 194)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("peanutbutter sandwiches: ", x0.varValue)
        print("oreos: ", x1.varValue)
        print("kiwis: ", x2.varValue)
        print("fruit salads: ", x3.varValue)
        print("milkshakes: ", x4.varValue)
        print("eggs: ", x5.varValue)
    else:
        print("No optimal solution found")

optimization_problem()
