
import gurobipy as gp

# Create a new model
m = gp.Model("work_optimization")

# Create variables
workers = ['George', 'Hank', 'Bill', 'Paul', 'John', 'Jean']
hours = m.addVars(workers, name="hours", vtype=gp.GRB.INTEGER)

# Set objective function
m.setObjective(3.19 * hours['George'] + 1.77 * hours['Hank'] + 6.85 * hours['Bill'] + 9.88 * hours['Paul'] + 5.22 * hours['John'] + 5.42 * hours['Jean'], gp.GRB.MAXIMIZE)

# Work quality rating
work_quality = {'George': 9, 'Hank': 5, 'Bill': 9, 'Paul': 8, 'John': 7, 'Jean': 6}
# Dollar cost per hour
dollar_cost = {'George': 21, 'Hank': 8, 'Bill': 3, 'Paul': 21, 'John': 7, 'Jean': 15}


# Add constraints based on the provided input


# Quality constraints
m.addConstr(work_quality['Hank'] * hours['Hank'] + work_quality['Paul'] * hours['Paul'] + work_quality['Jean'] * hours['Jean'] >= 97)
m.addConstr(work_quality['Bill'] * hours['Bill'] + work_quality['Paul'] * hours['Paul'] + work_quality['John'] * hours['John'] >= 97)
# ... (add all other quality constraints similarly)

# Cost constraints
m.addConstr(dollar_cost['George'] * hours['George'] + dollar_cost['Bill'] * hours['Bill'] + dollar_cost['Jean'] * hours['Jean'] >= 56)
m.addConstr(dollar_cost['George'] * hours['George'] + dollar_cost['Bill'] * hours['Bill'] + dollar_cost['John'] * hours['John'] >= 56)
# ... (add all other cost constraints similarly)


# Quality upper bound constraints
m.addConstr(work_quality['George'] * hours['George'] + work_quality['John'] * hours['John'] <= 366)
m.addConstr(work_quality['Bill'] * hours['Bill'] + work_quality['Jean'] * hours['Jean'] <= 179)
# ... (add all other quality upper bound constraints similarly)

# Cost upper bound constraints
m.addConstr(dollar_cost['Bill'] * hours['Bill'] + dollar_cost['Jean'] * hours['Jean'] <= 529)
m.addConstr(dollar_cost['John'] * hours['John'] + dollar_cost['Jean'] * hours['Jean'] <= 292)
# ... (add all other cost upper bound constraints similarly)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
    print('Obj: %g' % m.objVal)
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

