
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=GRB.INTEGER, name="Mbps bandwidth allocated to monitoring")
    x1 = m.addVar(vtype=GRB.INTEGER, name="network administrators")


    # Set objective function
    m.setObjective(4*x0**2 + 4*x0, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(17*x0 + 9*x1 >= 15, "cost_lower_bound")
    m.addConstr(17*x0 + 17*x1 >= 11, "impact_lower_bound")
    m.addConstr(4*x0 - 6*x1 >= 0, "bandwidth_admin_relation")
    m.addConstr(17*x0 + 9*x1 <= 55, "cost_upper_bound")
    m.addConstr(17*x0**2 + 17*x1**2 <= 18, "impact_squared_upper_bound")


    # Optimize model
    m.optimize()

    # Check for infeasibility
    if m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal solution found:")
        for v in m.getVars():
            print(f"{v.varName}: {v.x}")
        print(f"Objective value: {m.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e.message}")

except AttributeError:
    print("Encountered an attribute error")
