
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x0 = m.addVar(vtype=GRB.INTEGER, name="Mbps_bandwidth_allocated_to_monitoring")
x1 = m.addVar(vtype=GRB.INTEGER, name="network_administrators")

# Set the objective function
m.setObjective(4*x0**2 + 4*x0, GRB.MINIMIZE)

# Add constraints
m.addConstr(17*x0 + 9*x1 >= 15, "Minimum_total_cost")
m.addConstr(17*x0 + 17*x1 >= 11, "Minimum_total_data_integrity_impact")
m.addConstr(4*x0 - 6*x1 >= 0, "Combined_linear_constraint")
m.addConstr(17*x0 + 9*x1 <= 55, "Maximum_total_cost")
# Note: The following constraint might need adjustment based on the actual problem intent
m.addConstr((17*x0)**2 + (17*x1)**2 <= 18, "Maximum_combined_data_integrity_impact_squared")

# Solve the model
m.optimize()

# Print the solution
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print(f"Objective: {m.objVal}")
