
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name='Mbps_bandwidth', vtype=gurobi.GRB.INTEGER)  # Mbps bandwidth allocated to monitoring
x2 = model.addVar(name='network_administrators', vtype=gurobi.GRB.INTEGER)  # network administrators

# Objective function: minimize 4*x1^2 + 4*x1
model.setObjective(4*x1**2 + 4*x1, gurobi.GRB.MINIMIZE)

# Constraints
model.addConstr(17*x1 + 9*x2 >= 15, name='budget_min')
model.addConstr(17*x1 + 17*x2 >= 11, name='data_integrity_min')
model.addConstr(4*x1 - 6*x2 >= 0, name='ratio_constraint')
model.addConstr(17*x1 + 9*x2 <= 57, name='budget_max')
model.addConstr(x1**2 + x2**2 <= 18, name='data_integrity_max')

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print('Optimal solution found.')
    print(f'Mbps bandwidth allocated to monitoring: {x1.varValue}')
    print(f'network administrators: {x2.varValue}')
    print(f'Objective: {model.objVal}')
else:
    print('No optimal solution found.')
