
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
mary = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="mary")
bill = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="bill")
john = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="john")
bobby = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="bobby")

# Set objective function
m.setObjective(9.41 * mary + 6.59 * bill + 3.37 * john + 1.98 * bobby, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5 * bill + 2 * john + 2 * bobby >= 4, "c1")
m.addConstr(4 * mary + 5 * bill + 2 * john >= 4, "c2")


m.addConstr(4 * mary + bill + 3 * john >= 8, "c3")
m.addConstr(4 * bill + 4 * john >= 7, "c4")
m.addConstr(4 * bill + 4 * john + 3 * bobby >= 5, "c5")
m.addConstr(2 * mary + 4 * john + 3 * bobby >= 5, "c6")
m.addConstr(4 * bill + 4 * john + 3 * bobby >= 7, "c7")
m.addConstr(2 * mary + 4 * john + 3 * bobby >= 7, "c8")
m.addConstr(4 * mary + 2 * bobby <= 15, "c9")
m.addConstr(4 * mary + 5 * bill <= 14, "c10")
m.addConstr(4 * mary + 5 * bill + 2 * bobby <= 10, "c11")
m.addConstr(4 * mary + 5 * bill + 2 * john + 2 * bobby <= 10, "c12")
m.addConstr(bill + 3 * john <= 29, "c13")
m.addConstr(3 * john + 3 * bobby <= 19, "c14")
m.addConstr(4 * mary + bill <= 17, "c15")
m.addConstr(bill + 3 * john + 3 * bobby <= 25, "c16")
m.addConstr(4 * mary + 3 * john + 3 * bobby <= 13, "c17")
m.addConstr(4 * mary + bill + 3 * bobby <= 22, "c18")
m.addConstr(4 * mary + bill + 3 * john + 3 * bobby <= 22, "c19")
m.addConstr(4 * bill + 4 * john <= 22, "c20")
m.addConstr(2 * mary + 3 * bobby <= 7, "c21")
m.addConstr(4 * john + 3 * bobby <= 14, "c22")
m.addConstr(2 * mary + 4 * john <= 23, "c23")
m.addConstr(2 * mary + 4 * bill + 4 * john + 3 * bobby <= 23, "c24")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

