
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(lb=0, name="hours_worked_by_Mary")  # Can be fractional
x1 = m.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="hours_worked_by_Bill")  # Must be an integer
x2 = m.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="hours_worked_by_John")  # Must be an integer
x3 = m.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="hours_worked_by_Bobby")  # Must be an integer

# Define the objective function
m.setObjective(9.41*x0 + 6.59*x1 + 3.37*x2 + 1.98*x3, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x1 + 2*x2 + 2*x3 >= 4, name="productivity_rating_Bill_John_Bobby")
m.addConstr(4*x0 + 5*x1 + 2*x2 >= 4, name="productivity_rating_Mary_Bill_John")
m.addConstr(4*x0 + x1 + 3*x2 + 3*x3 >= 8, name="organization_score_Mary_Bill_John_Bobby")
m.addConstr(4*x1 + 4*x2 >= 7, name="dollar_cost_Bill_John")
m.addConstr(4*x1 + 4*x2 + 3*x3 >= 5, name="dollar_cost_Bill_John_Bobby_1")
m.addConstr(2*x0 + 4*x2 + 3*x3 >= 5, name="dollar_cost_Mary_John_Bobby")
m.addConstr(4*x1 + 4*x2 + 3*x3 >= 7, name="dollar_cost_Bill_John_Bobby_2")
m.addConstr(2*x0 + 4*x2 + 3*x3 >= 7, name="dollar_cost_Mary_John_Bobby_2")
m.addConstr(4*x0 + 2*x3 <= 15, name="productivity_rating_Mary_Bobby")
m.addConstr(4*x0 + 5*x1 <= 14, name="productivity_rating_Mary_Bill")
m.addConstr(4*x0 + 5*x1 + 2*x3 <= 10, name="productivity_rating_Mary_Bill_Bobby")
m.addConstr(4*x0 + 5*x1 + 2*x2 + 2*x3 <= 10, name="productivity_rating_all")
m.addConstr(x1 + 3*x2 <= 29, name="organization_score_Bill_John")
m.addConstr(3*x2 + 3*x3 <= 19, name="organization_score_John_Bobby")
m.addConstr(4*x0 + x1 <= 17, name="organization_score_Mary_Bill")
m.addConstr(x1 + 3*x2 + 3*x3 <= 25, name="organization_score_Bill_John_Bobby")
m.addConstr(4*x0 + 3*x2 + 3*x3 <= 13, name="organization_score_Mary_John_Bobby")
m.addConstr(4*x0 + x1 + 3*x3 <= 22, name="organization_score_Mary_Bill_Bobby")
m.addConstr(4*x0 + 5*x1 + 2*x2 + 2*x3 <= 22, name="organization_score_all")
m.addConstr(4*x1 + 4*x2 <= 22, name="dollar_cost_Bill_John")
m.addConstr(2*x0 + 3*x3 <= 7, name="dollar_cost_Mary_Bobby")
m.addConstr(4*x2 + 3*x3 <= 14, name="dollar_cost_John_Bobby")
m.addConstr(2*x0 + 4*x2 <= 23, name="dollar_cost_Mary_John")
m.addConstr(2*x0 + 4*x1 + 4*x2 + 3*x3 <= 23, name="dollar_cost_all")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Mary: ", x0.varValue)
    print("Hours worked by Bill: ", x1.varValue)
    print("Hours worked by John: ", x2.varValue)
    print("Hours worked by Bobby: ", x3.varValue)
else:
    print("The model is infeasible")
