
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours worked by John")
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours worked by Hank")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="hours worked by Ringo")
x3 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours worked by George")


# Set objective function
m.setObjective(7.06*x0**2 + 5.23*x0*x1 + 9.99*x1**2 + 9.34*x1*x2 + 4.35*x1*x3 + 4.75*x2*x3 + 10.0*x3**2 + 8.85*x2 + 4.39*x3, GRB.MINIMIZE)

# Add constraints
m.addConstr(12*x1 + 17*x3 >= 29)
m.addConstr(19*x0 + 12*x1 >= 36)
m.addConstr(21*x2 + 17*x3 >= 23)
m.addConstr(12*x1 + 21*x2 + 17*x3 >= 36)
m.addConstr(19*x0 + 12*x1 + 21*x2 + 17*x3 >= 36)
m.addConstr(6*x0 + 1*x3 >= 26)
m.addConstr(6*x0**2 + 7*x1**2 >= 8)
m.addConstr(22*x2 + 1*x3 >= 15)
m.addConstr(6*x0 + 7*x1 + 1*x3 >= 23)
m.addConstr(6*x0 + 7*x1 + 22*x2 + 1*x3 >= 23)
m.addConstr(8*x1 + 3*x2 >= 107)
m.addConstr(1*x0 + 29*x3 >= 52)
m.addConstr(1*x0**2 + 3*x2**2 >= 42)
m.addConstr(1*x0 + 3*x2 + 29*x3 >= 81)
m.addConstr(1*x0 + 8*x1 + 3*x2 + 29*x3 >= 81)
m.addConstr(28*x1**2 + 11*x2**2 >= 33)
m.addConstr(13*x0 + 28*x1 >= 29)
m.addConstr(11*x2 + 15*x3 >= 37)
m.addConstr(13*x0 + 15*x3 >= 33)
m.addConstr(13*x0 + 11*x2 >= 27)
m.addConstr(13*x0 + 28*x1 + 11*x2 >= 36)
m.addConstr(28*x1**2 + 11*x2**2 + 15*x3**2 >= 36)
m.addConstr(13*x0 + 28*x1 + 15*x3 >= 36)
m.addConstr(13*x0 + 28*x1 + 11*x2 >= 52)
m.addConstr(28*x1 + 11*x2 + 15*x3 >= 52)
m.addConstr(13*x0 + 28*x1 + 15*x3 >= 52)
m.addConstr(13*x0**2 + 28*x1**2 + 11*x2**2 >= 47)
m.addConstr(28*x1**2 + 11*x2**2 + 15*x3**2 >= 47)
m.addConstr(13*x0**2 + 28*x1**2 + 15*x3**2 >= 47)
m.addConstr(13*x0 + 28*x1 + 11*x2 + 15*x3 >= 47)
m.addConstr(-3*x0 + 7*x1 >= 0)
m.addConstr(-2*x0 + 1*x2 >= 0)
m.addConstr(21*x2 + 17*x3 <= 152)
m.addConstr(12*x1 + 17*x3 <= 134)
m.addConstr(19*x0 + 21*x2 <= 195)
m.addConstr(7*x1 + 1*x3 <= 46)
m.addConstr(6*x0 + 7*x1 <= 52)
m.addConstr(22*x2 + 1*x3 <= 60)
m.addConstr(6*x0 + 1*x3 <= 60)
m.addConstr(1*x0 + 8*x1 + 3*x2 <= 396)
m.addConstr(1*x0 + 3*x2 + 29*x3 <= 432)
m.addConstr(13*x0 + 11*x2 <= 205)
m.addConstr(28*x1 + 11*x2 <= 119)
m.addConstr(13*x0 + 28*x1 <= 139)
m.addConstr(28*x1 + 11*x2 + 15*x3 <= 126)



# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

