
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
x = m.addVars(7, lb=0, vtype=gp.GRB.CONTINUOUS, name=["Paul", "Bill", "George", "Hank", "John", "Ringo", "Jean"])


# Set objective function
m.setObjective(6.63 * x[0] + 4.33 * x[1] + 2.22 * x[2] + 7.29 * x[3] + 2.29 * x[4] + 6.9 * x[5] + 1.01 * x[6], gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(2 * x[2] + 11 * x[6] >= 13)
m.addConstr(8 * x[0] + 11 * x[4] >= 22)
m.addConstr(2 * x[2] + 6 * x[5] >= 12)
m.addConstr(11 * x[1] + 2 * x[3] >= 28)
m.addConstr(11 * x[1] + 2 * x[2] >= 13)
m.addConstr(2 * x[3] + 6 * x[5] >= 20)
m.addConstr(6 * x[5] + 11 * x[6] >= 17)
m.addConstr(8 * x[0] + 2 * x[3] >= 26)
m.addConstr(11 * x[4] + 6 * x[5] >= 27)
m.addConstr(8 * x[0] + 11 * x[6] >= 11)
m.addConstr(2 * x[2] + 2 * x[3] <= 183)
m.addConstr(2 * x[2] + 6 * x[5] <= 198)
m.addConstr(11 * x[4] + 11 * x[6] <= 96)
m.addConstr(6 * x[5] + 11 * x[6] <= 33)
m.addConstr(11 * x[4] + 6 * x[5] <= 167)
m.addConstr(8 * x[0] + 6 * x[5] <= 71)
m.addConstr(2 * x[3] + 11 * x[4] <= 64)
m.addConstr(2 * x[3] + 6 * x[5] <= 52)
m.addConstr(8 * x[0] + 2 * x[3] <= 138)
m.addConstr(8 * x[0] + 2 * x[2] <= 49)
m.addConstr(11 * x[1] + 2 * x[2] <= 36)
m.addConstr(11 * x[1] + 2 * x[2] + 2 * x[3] <= 75)
m.addConstr(2 * x[2] + 2 * x[3] + 6 * x[5] <= 165)
m.addConstr(2 * x[3] + 6 * x[5] + 11 * x[6] <= 205)
m.addConstr(11 * x[1] + 2 * x[2] + 11 * x[4] <= 93)
m.addConstr(8 * x[0] + 2 * x[3] + 6 * x[5] <= 192)
m.addConstr(8 * x[0] + 11 * x[1] + 11 * x[6] <= 101)
m.addConstr(2 * x[2] + 11 * x[4] + 11 * x[6] <= 140)
m.addConstr(8 * x[0] + 6 * x[5] + 11 * x[6] <= 208)
m.addConstr(2 * x[3] + 11 * x[4] + 11 * x[6] <= 76)
m.addConstr(11 * x[1] + 11 * x[4] + 11 * x[6] <= 151)
m.addConstr(8 * x[0] + 11 * x[1] + 2 * x[2] + 2 * x[3] + 11 * x[4] + 6 * x[5] + 11 * x[6] <= 151)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective Value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

