
import gurobi

def optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='x1', lb=0)  # hours worked by Paul
    x2 = model.addVar(name='x2', lb=0)  # hours worked by Bill
    x3 = model.addVar(name='x3', lb=0)  # hours worked by George
    x4 = model.addVar(name='x4', lb=0)  # hours worked by Hank
    x5 = model.addVar(name='x5', lb=0)  # hours worked by John
    x6 = model.addVar(name='x6', lb=0)  # hours worked by Ringo
    x7 = model.addVar(name='x7', lb=0)  # hours worked by Jean

    # Objective function
    model.setObjective(6.63*x1 + 4.33*x2 + 2.22*x3 + 7.29*x4 + 2.29*x5 + 6.9*x6 + 1.01*x7, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(2*x3 + 11*x7 >= 13)
    model.addConstr(8*x1 + 11*x5 >= 22)
    model.addConstr(2*x3 + 6*x6 >= 12)
    model.addConstr(11*x2 + 2*x4 >= 28)
    model.addConstr(11*x2 + 2*x3 >= 13)
    model.addConstr(2*x4 + 6*x6 >= 20)
    model.addConstr(6*x6 + 11*x7 >= 17)
    model.addConstr(8*x1 + 2*x4 >= 26)
    model.addConstr(11*x5 + 6*x6 >= 27)
    model.addConstr(8*x1 + 11*x7 >= 11)
    model.addConstr(2*x3 + 2*x4 <= 183)
    model.addConstr(2*x3 + 6*x6 <= 198)
    model.addConstr(11*x5 + 11*x7 <= 96)
    model.addConstr(6*x6 + 11*x7 <= 33)
    model.addConstr(11*x5 + 6*x6 <= 167)
    model.addConstr(8*x1 + 6*x6 <= 71)
    model.addConstr(2*x4 + 11*x5 <= 64)
    model.addConstr(2*x4 + 6*x6 <= 52)
    model.addConstr(8*x1 + 2*x4 <= 138)
    model.addConstr(8*x1 + 2*x3 <= 49)
    model.addConstr(11*x2 + 2*x3 <= 36)
    model.addConstr(11*x2 + 2*x3 + 2*x4 <= 75)
    model.addConstr(2*x3 + 2*x4 + 6*x6 <= 165)
    model.addConstr(2*x4 + 6*x6 + 11*x7 <= 205)
    model.addConstr(11*x2 + 2*x3 + 11*x5 <= 93)
    model.addConstr(8*x1 + 2*x4 + 6*x6 <= 192)
    model.addConstr(8*x1 + 11*x2 + 11*x7 <= 101)
    model.addConstr(2*x3 + 11*x5 + 11*x7 <= 140)
    model.addConstr(8*x1 + 6*x6 + 11*x7 <= 208)
    model.addConstr(2*x4 + 11*x5 + 11*x7 <= 76)
    model.addConstr(11*x2 + 11*x5 + 11*x7 <= 151)
    model.addConstr(8*x1 + 11*x2 + 2*x3 + 2*x4 + 11*x5 + 6*x6 + 11*x7 <= 151)

    # Optimize the model
    model.optimize()

    # Print the objective value
    print('Objective value:', model.objVal)

    # Print the variable values
    print('x1:', x1.varValue)
    print('x2:', x2.varValue)
    print('x3:', x3.varValue)
    print('x4:', x4.varValue)
    print('x5:', x5.varValue)
    print('x6:', x6.varValue)
    print('x7:', x7.varValue)

optimization_problem()
