
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_model")

# Create variables
x = m.addVars(5, lb=0, vtype=gp.GRB.CONTINUOUS, name=["Paul", "Mary", "Peggy", "Jean", "Laura"])

# Set objective function
m.setObjective(8.01*x[0]**2 + 2.85*x[0]*x[1] + 4.45*x[0]*x[2] + 9.87*x[0]*x[4] + 7.71*x[1]**2 + 5.93*x[1]*x[2] + 5.22*x[1]*x[4] + 7.18*x[2]**2 + 6.06*x[2]*x[4] + 5.23*x[3]**2 + 9.39*x[3]*x[4] + 9.02*x[0] + 9.92*x[1] + 4.45*x[2], gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(17*x[2] + 3*x[3] + 20*x[4] >= 36)
m.addConstr(22*x[1] + 17*x[2] + 3*x[3] >= 36)
m.addConstr(12*x[0]**2 + 3*x[3]**2 + 20*x[4]**2 >= 36)
m.addConstr(12*x[0] + 17*x[2] + 20*x[4] >= 36)
m.addConstr(12*x[0]**2 + 22*x[1]**2 + 17*x[2]**2 >= 36)
m.addConstr(12*x[0] + 17*x[2] + 3*x[3] >= 36)
m.addConstr(17*x[2]**2 + 3*x[3]**2 + 20*x[4]**2 >= 35)
m.addConstr(22*x[1] + 17*x[2] + 3*x[3] >= 35)
m.addConstr(12*x[0] + 3*x[3] + 20*x[4] >= 35)
m.addConstr(12*x[0]**2 + 17*x[2]**2 + 20*x[4]**2 >= 35)
m.addConstr(12*x[0]**2 + 22*x[1]**2 + 17*x[2]**2 >= 35)
m.addConstr(12*x[0]**2 + 17*x[2]**2 + 3*x[3]**2 >= 35)
m.addConstr(17*x[2]**2 + 3*x[3]**2 + 20*x[4]**2 >= 30)
m.addConstr(22*x[1] + 17*x[2] + 3*x[3] >= 30)
m.addConstr(12*x[0] + 3*x[3] + 20*x[4] >= 30)
m.addConstr(12*x[0]**2 + 17*x[2]**2 + 20*x[4]**2 >= 30)
m.addConstr(12*x[0] + 22*x[1] + 17*x[2] >= 30)
m.addConstr(12*x[0]**2 + 17*x[2]**2 + 3*x[3]**2 >= 30)
m.addConstr(17*x[2] + 3*x[3] + 20*x[4] >= 29)
m.addConstr(22*x[1] + 17*x[2] + 3*x[3] >= 29)
m.addConstr(12*x[0]**2 + 3*x[3]**2 + 20*x[4]**2 >= 29)
m.addConstr(12*x[0]**2 + 17*x[2]**2 + 20*x[4]**2 >= 29)
m.addConstr(12*x[0]**2 + 22*x[1]**2 + 17*x[2]**2 >= 29)
m.addConstr(12*x[0]**2 + 17*x[2]**2 + 3*x[3]**2 >= 29)
m.addConstr(17*x[2] + 3*x[3] + 20*x[4] >= 40)
m.addConstr(22*x[1] + 17*x[2] + 3*x[3] >= 40)
m.addConstr(12*x[0]**2 + 3*x[3]**2 + 20*x[4]**2 >= 40)
m.addConstr(12*x[0] + 17*x[2] + 20*x[4] >= 40)
m.addConstr(12*x[0]**2 + 22*x[1]**2 + 17*x[2]**2 >= 40)
m.addConstr(12*x[0] + 17*x[2] + 3*x[3] >= 40)
m.addConstr(17*x[2] + 3*x[3] + 20*x[4] >= 25)
m.addConstr(22*x[1] + 17*x[2] + 3*x[3] >= 25)
m.addConstr(12*x[0] + 3*x[3] + 20*x[4] >= 25)
m.addConstr(12*x[0] + 17*x[2] + 20*x[4] >= 25)
m.addConstr(12*x[0]**2 + 22*x[1]**2 + 17*x[2]**2 >= 25)
m.addConstr(12*x[0]**2 + 17*x[2]**2 + 3*x[3]**2 >= 25)
m.addConstr(7*x[1] - 9*x[2] - 8*x[3] >= 0)
m.addConstr(12*x[0]**2 + 3*x[3]**2 <= 150)
m.addConstr(22*x[1]**2 + 20*x[4]**2 <= 103)
m.addConstr(22*x[1] + 3*x[3] <= 193)
m.addConstr(3*x[3] + 20*x[4] <= 139)
m.addConstr(22*x[1]**2 + 17*x[2]**2 <= 219)
m.addConstr(12*x[0] + 17*x[2] <= 164)
m.addConstr(17*x[2]**2 + 3*x[3]**2 <= 114)
m.addConstr(12*x[0] + 22*x[1] + 17*x[2] + 3*x[3] + 20*x[4] <= 114)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    for v in m.getVars():
        print(f'{v.varName}: {v.x}')
    print(f'Obj: {m.objVal}')
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

