
import gurobipy as gp

# Create a new model
model = gp.Model("minimize_likelihood_to_quit")

# Create variables
bill_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bill_hours")
mary_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="mary_hours")
peggy_hours = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="peggy_hours")


# Set objective function
model.setObjective(8.53 * bill_hours + 1.19 * mary_hours + 3.23 * peggy_hours, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(11 * bill_hours <= 144, "c0")
model.addConstr(3 * mary_hours <= 144, "c1")
model.addConstr(8 * peggy_hours <= 144, "c2")
model.addConstr(3 * mary_hours + 8 * peggy_hours >= 30, "c3")
model.addConstr(11 * bill_hours + 8 * peggy_hours >= 30, "c4")
model.addConstr(11 * bill_hours + 3 * mary_hours + 8 * peggy_hours >= 30, "c5")
model.addConstr(6 * mary_hours - 2 * peggy_hours >= 0, "c6")
model.addConstr(11 * bill_hours + 3 * mary_hours + 8 * peggy_hours <= 122, "c7")



# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print(f"Bill's hours: {bill_hours.x}")
    print(f"Mary's hours: {mary_hours.x}")
    print(f"Peggy's hours: {peggy_hours.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

