
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="hours_worked_by_Bill", lb=0)
    x2 = model.addVar(name="hours_worked_by_Mary", lb=0)
    x3 = model.addVar(name="hours_worked_by_Peggy", lb=0, integrality=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(8.53 * x1 + 1.19 * x2 + 3.23 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(x1 <= 144 / 11)
    model.addConstr(x2 <= 144 / 3)
    model.addConstr(x3 <= 144 / 8)
    model.addConstr(3 * x2 + 8 * x3 >= 30)
    model.addConstr(11 * x1 + 8 * x3 >= 30)
    model.addConstr(11 * x1 + 3 * x2 + 8 * x3 >= 30)
    model.addConstr(6 * x2 - 2 * x3 >= 0)
    model.addConstr(11 * x1 + 3 * x2 + 8 * x3 <= 122)

    # Optimize
    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Bill: {x1.varValue}")
        print(f"Hours worked by Mary: {x2.varValue}")
        print(f"Hours worked by Peggy: {x3.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The problem is infeasible.")
    else:
        print("No solution found.")

solve_optimization_problem()
