
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("kidney_optimization")

    # Create variables
    protein = m.addVar(name="protein", lb=0)  # grams of protein
    vitamin_k = m.addVar(name="vitamin_k", lb=0)  # milligrams of vitamin K
    carbs = m.addVar(name="carbs", lb=0)  # grams of carbohydrates


    # Set objective function
    m.setObjective(4 * protein + 8 * vitamin_k + 9 * carbs, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(11.41 * protein + 8.05 * carbs >= 51, "c1")
    m.addConstr(2.81 * vitamin_k + 8.05 * carbs <= 369, "c2")
    m.addConstr(11.41 * protein + 2.81 * vitamin_k + 8.05 * carbs <= 374, "c3")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Optimal objective value: %g' % m.objVal)
        print('Protein: %g' % protein.x)
        print('Vitamin K: %g' % vitamin_k.x)
        print('Carbs: %g' % carbs.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

