
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="grams_of_protein")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_K")
x3 = m.addVar(vtype=GRB.CONTINUOUS, name="grams_of_carbohydrates")

# Define the objective function
m.setObjective(4*x1 + 8*x2 + 9*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(11.41*x1 + 8.05*x3 >= 51, "kidney_support_index_protein_carbs")
m.addConstr(2.81*x2 + 8.05*x3 <= 369, "kidney_support_index_vitaminK_carbs")
m.addConstr(11.41*x1 + 2.81*x2 + 8.05*x3 <= 369, "total_kidney_support_index")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Grams of Protein: {x1.x}")
    print(f"Milligrams of Vitamin K: {x2.x}")
    print(f"Grams of Carbohydrates: {x3.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
