
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="protein", lb=0)  # grams of protein
    x2 = model.addVar(name="vitamin_K", lb=0)  # milligrams of vitamin K
    x3 = model.addVar(name="carbohydrates", lb=0)  # grams of carbohydrates

    # Define the objective function
    model.setObjective(4 * x1 + 8 * x2 + 9 * x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(11.41 * x1 <= 374, name="protein_kidney_support")
    model.addConstr(2.81 * x2 <= 374, name="vitamin_K_kidney_support")
    model.addConstr(8.05 * x3 <= 374, name="carbohydrates_kidney_support")
    model.addConstr(11.41 * x1 + 8.05 * x3 >= 51, name="protein_carbohydrates_kidney_support")
    model.addConstr(2.81 * x2 + 8.05 * x3 <= 369, name="vitamin_K_carbohydrates_kidney_support")
    model.addConstr(11.41 * x1 + 2.81 * x2 + 8.05 * x3 <= 374, name="total_kidney_support")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Grams of protein: {x1.varValue}")
        print(f"Milligrams of vitamin K: {x2.varValue}")
        print(f"Grams of carbohydrates: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
