
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    bill_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bill_hours")
    george_hours = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="george_hours")
    laura_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura_hours")


    # Set objective function
    model.setObjective(7.46 * bill_hours + 6.91 * george_hours + 1.7 * laura_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(3 * bill_hours + 8 * george_hours <= 36, "paperwork_bill_george")
    model.addConstr(8 * george_hours + 2 * laura_hours <= 59, "paperwork_george_laura")
    model.addConstr(3 * bill_hours + 2 * laura_hours <= 73, "paperwork_bill_laura")
    model.addConstr(3 * bill_hours + 8 * george_hours + 2 * laura_hours <= 73, "paperwork_total")

    model.addConstr(3 * george_hours + 3 * laura_hours >= 17, "productivity_george_laura_min")
    model.addConstr(3 * george_hours + 3 * laura_hours <= 20, "productivity_george_laura_max")
    model.addConstr(4 * bill_hours + 3 * laura_hours <= 41, "productivity_bill_laura")
    model.addConstr(4 * bill_hours + 3 * george_hours + 3 * laura_hours <= 41, "productivity_total")

    model.addConstr(-4 * george_hours + 10 * laura_hours >= 0, "george_laura_relation")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('Bill Hours: %g' % bill_hours.x)
        print('George Hours: %g' % george_hours.x)
        print('Laura Hours: %g' % laura_hours.x)
    elif model.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
