
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", lb=0, ub=None)  # hours worked by Bill
    x1 = model.addVar(name="x1", lb=0, ub=None, vtype=gurobi.GRB.INTEGER)  # hours worked by George
    x2 = model.addVar(name="x2", lb=0, ub=None)  # hours worked by Laura

    # Define the objective function
    model.setObjective(7.46 * x0 + 6.91 * x1 + 1.7 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(3 * x0 <= 78)
    model.addConstr(4 * x0 <= 58)
    model.addConstr(8 * x1 <= 78)
    model.addConstr(3 * x1 <= 58)
    model.addConstr(2 * x2 <= 78)
    model.addConstr(3 * x2 <= 58)
    model.addConstr(3 * x1 + 3 * x2 >= 17)
    model.addConstr(-4 * x1 + 10 * x2 >= 0)
    model.addConstr(3 * x0 + 8 * x1 <= 36)
    model.addConstr(8 * x1 + 2 * x2 <= 59)
    model.addConstr(3 * x0 + 2 * x2 <= 73)
    model.addConstr(3 * x0 + 8 * x1 + 2 * x2 <= 73)
    model.addConstr(3 * x1 + 3 * x2 <= 20)
    model.addConstr(4 * x0 + 3 * x2 <= 41)
    model.addConstr(4 * x0 + 3 * x1 + 3 * x2 <= 41)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("x0: ", x0.varValue)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
