
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="fruit_salads")
x2 = m.addVar(vtype=GRB.INTEGER, name="potatoes")

# Objective function
m.setObjective(8.83*x1**2 + 6.48*x1*x2 + 3.67*x1 + 6.4*x2, GRB.MAXIMIZE)

# Constraints
m.addConstr(12*x1 + 8*x2 >= 25)
m.addConstr((8*x1)**2 + (15*x2)**2 >= 52)
m.addConstr(x1**2 - 10*x2**2 >= 0)
m.addConstr((12*x1)**2 + (8*x2)**2 <= 63)
m.addConstr(12*x1 + 8*x2 <= 63)
m.addConstr(8*x1 + 15*x2 <= 141)

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"fruit_salads: {x1.x}, potatoes: {x2.x}")
else:
    print("No optimal solution found.")
