
import gurobi as gp

# Create a new model
m = gp.Model()

# Define the variables
x1 = m.addVar(lb=0, name="fruit_salads")  # continuous
x2 = m.addVar(lb=0, type=gp.GRB.INTEGER, name="potatoes")  # integer

# Define the objective function
m.setObjective(8.83*x1**2 + 6.48*x1*x2 + 3.67*x1 + 6.4*x2, gp.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(12*x1 + 8*x2 >= 25, name="fat_constraint")
m.addConstr(8*x1**2 + x2**2 >= 52, name="iron_constraint")
m.addConstr(x1**2 - 10*x2**2 >= 0, name="ratio_constraint")
m.addConstr(144*x1**2 + 64*x2**2 <= 3969, name="fat_square_constraint")
m.addConstr(12*x1 + 8*x2 <= 63, name="fat_linear_constraint")
m.addConstr(8*x1 + 15*x2 <= 141, name="iron_linear_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Fruit Salads: ", x1.varValue)
    print("Potatoes: ", x2.varValue)
else:
    print("The model is infeasible")
