
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")  # milligrams of potassium
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")  # grams of fat
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")  # grams of fiber
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3")  # milligrams of calcium


# Set objective function
m.setObjective(5*x0 + 2*x1 + 4*x2 + 5*x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(25*x1 + 25*x3 >= 116)
m.addConstr(25*x1 + 10*x2 >= 90)
m.addConstr(24*x0 + 25*x3 >= 97)
m.addConstr(10*x2 + 25*x3 >= 97)
m.addConstr(24*x0 + 10*x2 + 25*x3 >= 109)
m.addConstr(24*x0 + 25*x1 + 10*x2 >= 109)
m.addConstr(24*x0 + 10*x2 + 25*x3 >= 106)
m.addConstr(24*x0 + 25*x1 + 10*x2 >= 106)
m.addConstr(19*x2 + 26*x3 >= 117)
m.addConstr(17*x0 + 26*x3 >= 104)
m.addConstr(24*x1 + 19*x2 >= 90)
m.addConstr(17*x0 + 24*x1 >= 113)
m.addConstr(24*x1 + 26*x3 >= 71)
m.addConstr(17*x0 + 24*x1 + 26*x3 >= 96)
m.addConstr(24*x1 + 19*x2 + 26*x3 >= 96)
m.addConstr(17*x0 + 24*x1 + 19*x2 >= 96)
m.addConstr(17*x0 + 24*x1 + 26*x3 >= 80)
m.addConstr(24*x1 + 19*x2 + 26*x3 >= 80)
m.addConstr(17*x0 + 24*x1 + 19*x2 >= 80)
m.addConstr(17*x0 + 24*x1 + 26*x3 >= 77)
m.addConstr(24*x1 + 19*x2 + 26*x3 >= 77)
m.addConstr(17*x0 + 24*x1 + 19*x2 >= 77)
m.addConstr(15*x1 + 28*x2 >= 70)
m.addConstr(-2*x0 + 9*x1 + 6*x2 >= 0)
m.addConstr(24*x0 + 25*x3 <= 537)
m.addConstr(25*x1 + 25*x3 <= 379)
m.addConstr(10*x2 + 25*x3 <= 255)
m.addConstr(24*x0 + 25*x1 + 10*x2 + 25*x3 <= 255)
m.addConstr(19*x2 + 26*x3 <= 462)
m.addConstr(24*x1 + 19*x2 <= 403)
m.addConstr(24*x1 + 26*x3 <= 474)
m.addConstr(17*x0 + 26*x3 <= 290)
m.addConstr(17*x0 + 24*x1 <= 195)
m.addConstr(17*x0 + 24*x1 + 19*x2 <= 499)
m.addConstr(17*x0 + 19*x2 + 26*x3 <= 405)
m.addConstr(17*x0 + 24*x1 + 26*x3 <= 256)
m.addConstr(17*x0 + 24*x1 + 19*x2 + 26*x3 <= 256)
m.addConstr(13*x0 + 28*x2 <= 151)
m.addConstr(15*x1 + 23*x3 <= 154)
m.addConstr(13*x0 + 23*x3 <= 159)
m.addConstr(15*x1 + 28*x2 <= 201)
m.addConstr(13*x0 + 15*x1 + 28*x2 <= 413)
m.addConstr(13*x0 + 15*x1 + 23*x3 <= 266)
m.addConstr(13*x0 + 15*x1 + 28*x2 + 23*x3 <= 266)
m.addConstr(16*x0 + 27*x1 <= 437)
m.addConstr(16*x0 + 27*x2 <= 256)
m.addConstr(16*x0 + 29*x3 <= 304)
m.addConstr(27*x1 + 27*x2 <= 313)
m.addConstr(27*x2 + 29*x3 <= 400)
m.addConstr(16*x0 + 27*x1 + 27*x2 <= 265)
m.addConstr(16*x0 + 27*x1 + 29*x3 <= 207)
m.addConstr(16*x0 + 27*x1 + 27*x2 + 29*x3 <= 207)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

