
from gurobipy import Model, GRB

# Create a new model
model = Model("Work_Hours_Optimization")

# Create variables
george = model.addVar(vtype=GRB.INTEGER, name="george")
ringo = model.addVar(vtype=GRB.INTEGER, name="ringo")
bobby = model.addVar(vtype=GRB.INTEGER, name="bobby")
jean = model.addVar(vtype=GRB.INTEGER, name="jean")
mary = model.addVar(vtype=GRB.INTEGER, name="mary")
laura = model.addVar(vtype=GRB.CONTINUOUS, name="laura")


# Set objective function
model.setObjective(5*george + 2*ringo + 4*bobby + 9*jean + 9*mary + 5*laura, GRB.MAXIMIZE)

# Add constraints
model.addConstr(6*jean + 7*mary >= 84)
model.addConstr(15*ringo + 7*mary >= 89)
model.addConstr(16*george + 7*mary >= 86)
model.addConstr(15*ringo + 6*jean >= 82)
model.addConstr(15*ringo + 6*jean + 16*laura >= 95)
model.addConstr(16*george + 15*ringo + 16*laura >= 95)
model.addConstr(6*jean + 7*mary + 16*laura >= 95)
model.addConstr(16*george + 12*bobby + 16*laura >= 95)
# ... (add all other constraints similarly)


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('George:', george.x)
    print('Ringo:', ringo.x)
    print('Bobby:', bobby.x)
    print('Jean:', jean.x)
    print('Mary:', mary.x)
    print('Laura:', laura.x)

elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

