
from gurobipy import *

# Create a new model
m = Model("Work Hours Optimization")

# Define variables (assuming they are all non-negative)
x1 = m.addVar(name="Hours worked by George", vtype=GRB.INTEGER) # Integer hours for George
x2 = m.addVar(name="Hours worked by Ringo", vtype=GRB.INTEGER) # Integer hours for Ringo
x3 = m.addVar(name="Hours worked by Bobby", vtype=GRB.INTEGER) # Integer hours for Bobby
x4 = m.addVar(name="Hours worked by Jean", vtype=GRB.INTEGER) # Integer hours for Jean
x5 = m.addVar(name="Hours worked by Mary", vtype=GRB.INTEGER) # Integer hours for Mary
x6 = m.addVar(name="Hours worked by Laura") # Non-integer hours allowed for Laura

# Set the objective function (example: maximize total hours)
m.setObjective(x1 + x2 + x3 + x4 + x5 + x6, GRB.MAXIMIZE)

# Add constraints (replace with actual problem constraints)
m.addConstr(x1 + x4 >= 30, name="Work Quality Constraint")
m.addConstr(x2 <= 40, name="Ringo Hours Limit")
m.addConstr(x3 + x5 <= 60, name="Bobby and Mary Hours Limit")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in m.getVars():
        print("%s = %g" % (v.varName, v.x))
else:
    print("No optimal solution found")
