
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x1 = m.addVar(name="hours_worked_by_George", lowBound=0, integrality=1)  # integer
x2 = m.addVar(name="hours_worked_by_Ringo", lowBound=0, integrality=1)  # integer
x3 = m.addVar(name="hours_worked_by_Bobby", lowBound=0, integrality=1)  # integer
x4 = m.addVar(name="hours_worked_by_Jean", lowBound=0, integrality=1)  # integer
x5 = m.addVar(name="hours_worked_by_Mary", lowBound=0, integrality=1)  # integer
x6 = m.addVar(name="hours_worked_by_Laura", lowBound=0)  # non-integer

# Objective function
m.setObjective(5*x1 + 2*x2 + 4*x3 + 9*x4 + 9*x5 + 5*x6, gp.GRB.MAXIMIZE)

# Constraints
# Likelihood to quit index constraints
m.addConstr(16*x1 + 15*x2 + 12*x3 + 6*x4 + 7*x5 + 16*x6 <= 584)
m.addConstr(16*x1 <= 584)
m.addConstr(15*x2 <= 584)
m.addConstr(12*x3 <= 584)
m.addConstr(6*x4 <= 584)
m.addConstr(7*x5 <= 584)
m.addConstr(16*x6 <= 584)
m.addConstr(16*x1 + 6*x4 + 7*x5 >= 84)
m.addConstr(15*x2 + 7*x5 >= 89)
m.addConstr(16*x1 + 7*x5 >= 86)
m.addConstr(15*x2 + 6*x4 >= 82)
m.addConstr(15*x2 + 6*x4 + 16*x6 >= 95)
m.addConstr(16*x1 + 15*x2 + 16*x6 >= 95)
m.addConstr(6*x4 + 7*x5 + 16*x6 >= 95)
m.addConstr(16*x1 + 12*x3 + 16*x6 >= 95)
m.addConstr(15*x2 + 6*x4 + 16*x6 >= 89)
m.addConstr(16*x1 + 15*x2 + 16*x6 >= 89)
m.addConstr(6*x4 + 7*x5 + 16*x6 >= 89)
m.addConstr(16*x1 + 12*x3 + 16*x6 >= 89)
m.addConstr(15*x2 + 6*x4 + 16*x6 >= 77)
m.addConstr(16*x1 + 15*x2 + 16*x6 >= 77)
m.addConstr(6*x4 + 7*x5 + 16*x6 >= 77)
m.addConstr(16*x1 + 12*x3 + 16*x6 >= 77)
m.addConstr(15*x2 + 6*x4 + 16*x6 >= 74)
m.addConstr(16*x1 + 15*x2 + 16*x6 >= 74)
m.addConstr(6*x4 + 7*x5 + 16*x6 >= 74)
m.addConstr(16*x1 + 12*x3 + 16*x6 >= 74)

# Productivity rating constraints
m.addConstr(3*x1 + 7*x2 + 8*x3 + 5*x4 + 17*x5 + 15*x6 <= 508)
m.addConstr(8*x3 + 5*x4 >= 78)
m.addConstr(8*x3 + 15*x6 >= 72)
m.addConstr(3*x1 + 15*x6 >= 76)
m.addConstr(3*x1 + 8*x3 >= 34)
m.addConstr(7*x2 + 17*x5 >= 60)
m.addConstr(3*x1 + 5*x4 >= 59)
m.addConstr(3*x1 + 17*x5 + 15*x6 >= 79)
m.addConstr(7*x2 + 17*x5 + 15*x6 >= 79)
m.addConstr(7*x2 + 5*x4 + 17*x5 >= 79)
m.addConstr(3*x1 + 8*x3 + 17*x5 >= 79)
m.addConstr(3*x1 + 17*x5 + 15*x6 >= 71)
m.addConstr(7*x2 + 17*x5 + 15*x6 >= 71)
m.addConstr(7*x2 + 5*x4 + 17*x5 >= 71)
m.addConstr(3*x1 + 8*x3 + 17*x5 >= 71)

# Work quality rating constraints
m.addConstr(16*x1 + 2*x2 + 1*x3 + 10*x4 + 9*x5 + 19*x6 <= 200)
m.addConstr(10*x4 + 19*x6 >= 30)
m.addConstr(2*x2 + 10*x4 >= 15)
m.addConstr(16*x1 + 19*x6 >= 11)
m.addConstr(16*x1 + 9*x5 >= 12)
m.addConstr(2*x2 + 9*x5 >= 13)
m.addConstr(2*x2 + 1*x3 >= 31)

# Computer competence rating constraints
m.addConstr(8*x1 + 6*x2 + 10*x3 + 3*x4 + 5*x5 + 5*x6 <= 446)
m.addConstr(8*x1 + 3*x4 >= 60)
m.addConstr(6*x2 + 5*x6 >= 31)
m.addConstr(10*x3 + 3*x4 >= 54)
m.addConstr(8*x1 + 5*x6 >= 32)
m.addConstr(6*x2 + 10*x3 >= 51)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by George: ", x1.varValue)
    print("Hours worked by Ringo: ", x2.varValue)
    print("Hours worked by Bobby: ", x3.varValue)
    print("Hours worked by Jean: ", x4.varValue)
    print("Hours worked by Mary: ", x5.varValue)
    print("Hours worked by Laura: ", x6.varValue)
else:
    print("No optimal solution found")
