
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("resource_optimization")

    # Create variables
    pen_testers = model.addVar(vtype=gp.GRB.INTEGER, name="pen_testers")
    intrusion_analysts = model.addVar(vtype=gp.GRB.INTEGER, name="intrusion_analysts")
    soc_operators = model.addVar(vtype=gp.GRB.INTEGER, name="soc_operators")


    # Set objective function
    model.setObjective(4 * pen_testers + 2 * intrusion_analysts + soc_operators, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(9 * pen_testers + 8 * intrusion_analysts + 10 * soc_operators <= 182, "computational_load")
    model.addConstr(9 * pen_testers + 21 * intrusion_analysts + 23 * soc_operators <= 190, "data_accessibility")
    model.addConstr(4 * pen_testers + 10 * intrusion_analysts + 12 * soc_operators <= 169, "power_consumption")
    model.addConstr(11 * pen_testers + 23 * intrusion_analysts + 21 * soc_operators <= 230, "network_latency")
    model.addConstr(21 * pen_testers + 10 * intrusion_analysts + 23 * soc_operators <= 129, "bandwidth")

    model.addConstr(9 * pen_testers + 10 * soc_operators >= 48, "c6")
    model.addConstr(8 * intrusion_analysts + 10 * soc_operators >= 46, "c7")
    model.addConstr(9 * pen_testers + 8 * intrusion_analysts + 10 * soc_operators >= 46, "c8")
    model.addConstr(9 * pen_testers + 21 * intrusion_analysts >= 23, "c9")
    model.addConstr(21 * intrusion_analysts + 23 * soc_operators >= 62, "c10")
    model.addConstr(9 * pen_testers + 23 * soc_operators >= 21, "c11")
    model.addConstr(9 * pen_testers + 21 * intrusion_analysts + 23 * soc_operators >= 21, "c12")
    model.addConstr(4 * pen_testers + 12 * soc_operators >= 30, "c13")
    model.addConstr(10 * intrusion_analysts + 12 * soc_operators >= 25, "c14")
    model.addConstr(4 * pen_testers + 10 * intrusion_analysts + 12 * soc_operators >= 53, "c15")
    model.addConstr(4 * pen_testers + 10 * intrusion_analysts + 12 * soc_operators >= 53, "c16")
    model.addConstr(11 * pen_testers + 23 * intrusion_analysts >= 70, "c17")
    model.addConstr(11 * pen_testers + 21 * soc_operators >= 73, "c18")
    model.addConstr(11 * pen_testers + 23 * intrusion_analysts + 21 * soc_operators >= 73, "c19")
    model.addConstr(21 * pen_testers + 23 * soc_operators >= 35, "c20")
    model.addConstr(21 * pen_testers + 10 * intrusion_analysts >= 27, "c21")
    model.addConstr(21 * pen_testers + 10 * intrusion_analysts + 23 * soc_operators >= 30, "c22")
    model.addConstr(21 * pen_testers + 10 * intrusion_analysts + 23 * soc_operators >= 30, "c23")
    model.addConstr(intrusion_analysts - 7 * soc_operators >= 0, "c24")
    model.addConstr(-pen_testers + 3 * intrusion_analysts >= 0, "c25")
    model.addConstr(9 * pen_testers + 8 * intrusion_analysts + 10 * soc_operators <= 79, "c26")
    model.addConstr(4 * pen_testers + 10 * intrusion_analysts <= 100, "c27")
    model.addConstr(4 * pen_testers + 12 * soc_operators <= 95, "c28")
    model.addConstr(10 * intrusion_analysts + 23 * soc_operators <= 123, "c29")
    model.addConstr(21 * pen_testers + 23 * soc_operators <= 103, "c30")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('pen_testers:', pen_testers.x)
        print('intrusion_analysts:', intrusion_analysts.x)
        print('soc_operators:', soc_operators.x)
    elif model.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
