
import gurobi

# Define the model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="pen_testers", vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name="intrusion_analysts", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="SOC_operators", vtype=gurobi.GRB.INTEGER)

# Define the objective function
m.setObjective(4*x0 + 2*x1 + x2, gurobi.GRB.MINIMIZE)

# Define the constraints
m.addConstr(9*x0 + 8*x1 + 10*x2 <= 182, name="computational_load")
m.addConstr(9*x0 + 21*x1 + 23*x2 <= 190, name="data_accessibility_impact")
m.addConstr(4*x0 + 10*x1 + 12*x2 <= 169, name="power_consumption")
m.addConstr(11*x0 + 23*x1 + 21*x2 <= 230, name="network_latency_impact")
m.addConstr(21*x0 + 10*x1 + 23*x2 <= 129, name="available_bandwidth_impact")

m.addConstr(9*x0 + 8*x1 + 10*x2 >= 48, name="computational_load_pen_testers_intrusion_analysts")
m.addConstr(8*x1 + 10*x2 >= 46, name="computational_load_intrusion_analysts_SOC_operators")
m.addConstr(9*x0 + 8*x1 + 10*x2 >= 46, name="total_computational_load")

m.addConstr(9*x0 + 21*x1 >= 23, name="data_accessibility_impact_pen_testers_intrusion_analysts")
m.addConstr(21*x1 + 23*x2 >= 62, name="data_accessibility_impact_intrusion_analysts_SOC_operators")
m.addConstr(9*x0 + 23*x2 >= 21, name="data_accessibility_impact_pen_testers_SOC_operators")
m.addConstr(9*x0 + 21*x1 + 23*x2 >= 21, name="total_data_accessibility_impact")

m.addConstr(4*x0 + 12*x2 >= 30, name="power_consumption_pen_testers_SOC_operators")
m.addConstr(10*x1 + 12*x2 >= 25, name="power_consumption_intrusion_analysts_SOC_operators")
m.addConstr(4*x0 + 10*x1 + 12*x2 >= 53, name="total_power_consumption")

m.addConstr(11*x0 + 23*x1 >= 70, name="network_latency_pen_testers_intrusion_analysts")
m.addConstr(11*x0 + 21*x2 >= 73, name="network_latency_pen_testers_SOC_operators")
m.addConstr(11*x0 + 23*x1 + 21*x2 >= 73, name="total_network_latency")

m.addConstr(21*x0 + 23*x2 >= 35, name="bandwidth_pen_testers_SOC_operators")
m.addConstr(21*x0 + 10*x1 >= 27, name="bandwidth_pen_testers_intrusion_analysts")
m.addConstr(21*x0 + 10*x1 + 23*x2 >= 30, name="total_bandwidth")

m.addConstr(x1 - 7*x2 >= 0, name="intrusion_analysts_SOC_operators_relationship")
m.addConstr(-x0 + 3*x1 >= 0, name="pen_testers_intrusion_analysts_relationship")

m.addConstr(9*x0 + 8*x1 + 10*x2 <= 79, name="total_computational_load_upper_bound")
m.addConstr(4*x0 + 10*x1 <= 100, name="power_consumption_pen_testers_intrusion_analysts_upper_bound")
m.addConstr(4*x0 + 12*x2 <= 95, name="power_consumption_pen_testers_SOC_operators_upper_bound")
m.addConstr(10*x1 + 23*x2 <= 123, name="bandwidth_intrusion_analysts_SOC_operators_upper_bound")
m.addConstr(21*x0 + 23*x2 <= 103, name="bandwidth_pen_testers_SOC_operators_upper_bound")

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("pen testers: ", x0.varValue)
    print("intrusion analysts: ", x1.varValue)
    print("SOC operators: ", x2.varValue)
else:
    print("The model is infeasible")
