
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=GRB.INTEGER, name="fruit_salads")
x1 = m.addVar(vtype=GRB.INTEGER, name="strawberries")
x2 = m.addVar(vtype=GRB.INTEGER, name="peanutbutter_sandwiches")


# Set objective function
m.setObjective(x0**2 + 3*x0*x1 + 5*x0*x2 + 9*x1**2 + 8*x0 + 8*x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(6*x0 + 15*x1 >= 68)
m.addConstr(15*x1 + 5*x2 >= 37)
m.addConstr(6*x0 + 5*x2 >= 27)
m.addConstr(5*x0 + 19*x2 >= 78)
m.addConstr(5*x0 + 1*x1 >= 40)
m.addConstr(15*x0**2 + 7*x1**2 >= 49)
m.addConstr(7*x1 + 12*x2 >= 88)
m.addConstr(15*x0 + 12*x2 >= 138)
m.addConstr(15*x1 + 5*x2 <= 196)
m.addConstr(6*x0**2 + 5*x2**2 <= 131)
m.addConstr(6*x0 + 15*x1 + 5*x2 <= 160)
m.addConstr(8*x0 + 20*x2 <= 140)
m.addConstr(8*x0 + 5*x1 <= 122)
m.addConstr(5*x0**2 + 1*x1**2 <= 232)
m.addConstr(5*x0 + 1*x1 + 19*x2 <= 232)
m.addConstr(7*x1**2 + 12*x2**2 <= 266)
m.addConstr(15*x0**2 + 7*x1**2 <= 160)
m.addConstr(15*x0 + 7*x1 + 12*x2 <= 160)


# Resource Constraints
m.addConstr(6*x0 <= 210)
m.addConstr(8*x0 <= 165)
m.addConstr(5*x0 <= 287)
m.addConstr(15*x0 <= 419)
m.addConstr(15*x1 <= 210)
m.addConstr(5*x1 <= 165)
m.addConstr(1*x1 <= 287)
m.addConstr(7*x1 <= 419)
m.addConstr(5*x2 <= 210)
m.addConstr(20*x2 <= 165)
m.addConstr(19*x2 <= 287)
m.addConstr(12*x2 <= 419)



# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

