
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="fruit_salads", vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name="strawberries", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="peanutbutter_sandwiches", vtype=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(1*x0**2 + 3*x0*x1 + 5*x0*x2 + 9*x1**2 + 8*x0 + 8*x1, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(6*x0 + 15*x1 >= 68)
m.addConstr(15*x1 + 5*x2 >= 37)
m.addConstr(6*x0 + 5*x2 >= 27)
m.addConstr(5*x0 + 19*x2 >= 78)
m.addConstr(5*x0 + x1 >= 40)
m.addConstr(15*x0**2 + 7*x1**2 >= 49)
m.addConstr(7*x1 + 12*x2 >= 88)
m.addConstr(15*x0 + 12*x2 >= 138)
m.addConstr(15*x1 + 5*x2 <= 196)
m.addConstr(6*x0**2 + 5*x2**2 <= 131)
m.addConstr(6*x0 + 15*x1 + 5*x2 <= 160)
m.addConstr(8*x0 + 20*x2 <= 140)
m.addConstr(8*x0 + 5*x1 <= 122)
m.addConstr(8*x0 + 5*x1 + 20*x2 <= 122)
m.addConstr(5*x0**2 + x1**2 <= 232)
m.addConstr(5*x0 + x1 + 19*x2 <= 232)
m.addConstr(7*x1**2 + 12*x2**2 <= 266)
m.addConstr(15*x0**2 + 7*x1**2 <= 160)
m.addConstr(15*x0 + 7*x1 + 12*x2 <= 160)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Fruit Salads: ", x0.varValue)
    print("Strawberries: ", x1.varValue)
    print("Peanutbutter Sandwiches: ", x2.varValue)
else:
    print("The model is infeasible")
