
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_model")

    # Create variables
    x0 = model.addVar(vtype=GRB.INTEGER, name="x0") # milligrams of vitamin B3 (integer)
    x1 = model.addVar(vtype=GRB.CONTINUOUS, name="x1") # milligrams of calcium (continuous)


    # Set objective function
    model.setObjective(x0 * x1 + 9 * x1**2 + 4 * x0 + 3 * x1, GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(3 * x0 <= 77, "c0")
    model.addConstr(1 * x0 <= 127, "c1")
    model.addConstr(8 * x0 <= 162, "c2")
    model.addConstr(3 * x1 <= 77, "c3")
    model.addConstr(4 * x1 <= 127, "c4")
    model.addConstr(11 * x1 <= 162, "c5")
    model.addConstr(3 * x0 + 3 * x1 >= 20, "c6")
    model.addConstr(x0**2 + 4 * x1**2 >= 56, "c7")
    model.addConstr(8 * x0 + 11 * x1 >= 61, "c8")
    model.addConstr(6 * x0**2 - 8 * x1**2 >= 0, "c9")
    model.addConstr(3 * x0 + 3 * x1 <= 66, "c10")
    model.addConstr(x0**2 + 4 * x1**2 <= 74, "c11")
    model.addConstr(x0 + 4 * x1 <= 74, "c12")
    model.addConstr(8 * x0**2 + 11 * x1**2 <= 95, "c13")
    model.addConstr(8 * x0 + 11 * x1 <= 95, "c14")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('x0: %g' % x0.x)
        print('x1: %g' % x1.x)
    elif model.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
