
import gurobi as gp

# Create a new model
m = gp.Model()

# Define variables
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="milligrams of vitamin B3")
x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="milligrams of calcium")

# Objective function
m.setObjective(x1*x2 + 9*x2**2 + 4*x1 + 3*x2, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(3*x1 == 3, name="muscle_growth_index_x1")
m.addConstr(x1 == 1, name="cardiovascular_support_index_x1")
m.addConstr(8*x1 == 8, name="digestive_support_index_x1")
m.addConstr(3*x2 == 3, name="muscle_growth_index_x2")
m.addConstr(4*x2 == 4, name="cardiovascular_support_index_x2")
m.addConstr(11*x2 == 11, name="digestive_support_index_x2")
m.addConstr(3*x1 + 3*x2 >= 20, name="total_muscle_growth_index")
m.addConstr(x1**2 + 16*x2**2 >= 56, name="total_cardiovascular_support_index")
m.addConstr(8*x1 + 11*x2 >= 61, name="total_digestive_support_index")
m.addConstr(6*x1**2 - 8*x2**2 >= 0, name="quadratic_constraint")
m.addConstr(3*x1 + 3*x2 <= 66, name="total_muscle_growth_index_upper_bound")
m.addConstr(x1**2 + 4*x2**2 <= 74, name="total_cardiovascular_support_index_upper_bound")
m.addConstr(8*x1 + 11*x2 <= 95, name="total_digestive_support_index_upper_bound")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"x1: {x1.varValue}, x2: {x2.varValue}")
else:
    print("No optimal solution found.")
