
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    hank = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hank")
    bill = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bill")
    laura = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="laura")
    jean = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="jean")

    # Set objective function
    obj = 4.7 * hank**2 + 1.48 * hank * bill + 8.34 * hank * jean + 9.02 * bill**2 + 1.32 * bill * jean + 5.27 * bill
    model.setObjective(obj, GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(4 * hank**2 + 9 * bill**2 + 6 * jean**2 >= 28, "c0")
    model.addConstr(9 * bill + 3 * laura + 6 * jean >= 28, "c1")
    model.addConstr(4 * hank + 9 * bill + 6 * jean >= 21, "c2")
    model.addConstr(9 * bill + 3 * laura + 6 * jean >= 21, "c3")  # Redundant constraint
    model.addConstr(3 * laura + 6 * jean <= 79, "c4")
    model.addConstr(4 * hank + 3 * laura <= 159, "c5")
    model.addConstr(4 * hank**2 + 6 * jean**2 <= 63, "c6")
    model.addConstr(4 * hank**2 + 9 * bill**2 <= 45, "c7")
    model.addConstr(9 * bill + 6 * jean <= 145, "c8")
    model.addConstr(4 * hank + 9 * bill + 3 * laura <= 70, "c9")
    model.addConstr(4 * hank + 3 * laura + 6 * jean <= 133, "c10")
    model.addConstr(4 * hank + 9 * bill + 3 * laura + 6 * jean <= 133, "c11")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
