
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="x1", lb=-gurobi.GRB.INFINITY)  # hours worked by Hank
x2 = m.addVar(name="x2", lb=-gurobi.GRB.INFINITY)  # hours worked by Bill
x3 = m.addVar(name="x3", lb=-gurobi.GRB.INFINITY)  # hours worked by Laura
x4 = m.addVar(name="x4", lb=-gurobi.GRB.INFINITY)  # hours worked by Jean

# Objective function
m.setObjective(4.7*x1**2 + 1.48*x1*x2 + 8.34*x1*x4 + 9.02*x2**2 + 1.32*x2*x4 + 5.27*x2, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(4*x1 <= 161)
m.addConstr(9*x2 <= 161)
m.addConstr(3*x3 <= 161)
m.addConstr(6*x4 <= 161)

m.addConstr(16*x1**2 + 81*x2**2 + 36*x4**2 >= 28)
m.addConstr(9*x2 + 3*x3 + 6*x4 >= 28)
m.addConstr(4*x1 + 9*x2 + 6*x4 >= 21)
m.addConstr(9*x2 + 3*x3 + 6*x4 >= 21)
m.addConstr(3*x3 + 6*x4 <= 79)
m.addConstr(4*x1 + 3*x3 <= 159)
m.addConstr(16*x1**2 + 36*x4**2 <= 63)
m.addConstr(16*x1**2 + 81*x2**2 <= 45)
m.addConstr(9*x2 + 6*x4 <= 145)
m.addConstr(4*x1 + 9*x2 + 3*x3 <= 70)
m.addConstr(4*x1 + 3*x3 + 6*x4 <= 133)
m.addConstr(4*x1 + 9*x2 + 3*x3 + 6*x4 <= 133)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
    print("x4: ", x4.varValue)
else:
    print("The model is infeasible")
