
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(name="milligrams_of_vitamin_B3")
    x1 = m.addVar(name="grams_of_fiber")


    # Set objective function
    m.setObjective(9.44 * x0 + 6.86 * x1, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(3 * x0 + 2 * x1 >= 17, "digestive_support_lower")
    m.addConstr(4 * x0 + 5 * x1 >= 12, "kidney_support_lower")
    m.addConstr(2 * x0 + 1 * x1 >= 15, "cognitive_performance_lower")
    m.addConstr(1 * x0 + 3 * x1 >= 2, "muscle_growth_lower")
    m.addConstr(3 * x0 + 3 * x1 >= 8, "immune_support_lower")
    m.addConstr(5 * x0 - 3 * x1 >= 0, "custom_constraint")

    m.addConstr(3 * x0 + 2 * x1 <= 34, "digestive_support_upper")
    m.addConstr(4 * x0 + 5 * x1 <= 34, "kidney_support_upper")
    m.addConstr(2 * x0 + 1 * x1 <= 44, "cognitive_performance_upper")
    m.addConstr(1 * x0 + 3 * x1 <= 10, "muscle_growth_upper")
    m.addConstr(3 * x0 + 3 * x1 <= 20, "immune_support_upper")



    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
