
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="milligrams_of_vitamin_B3", lb=0)  # No lower bound specified, assuming 0
    x2 = model.addVar(name="grams_of_fiber", lb=0)  # No lower bound specified, assuming 0

    # Objective function
    model.setObjective(9.44 * x1 + 6.86 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(3 * x1 + 2 * x2 >= 17, name="digestive_support_index")
    model.addConstr(4 * x1 + 5 * x2 >= 12, name="kidney_support_index")
    model.addConstr(2 * x1 + x2 >= 15, name="cognitive_performance_index")
    model.addConstr(x1 + 3 * x2 >= 2, name="muscle_growth_index")
    model.addConstr(3 * x1 + 3 * x2 >= 8, name="immune_support_index")
    model.addConstr(5 * x1 - 3 * x2 >= 0, name="linear_combination")
    model.addConstr(3 * x1 + 2 * x2 <= 34, name="digestive_support_index_upper_bound")
    model.addConstr(4 * x1 + 5 * x2 <= 34, name="kidney_support_index_upper_bound")
    model.addConstr(2 * x1 + x2 <= 44, name="cognitive_performance_index_upper_bound")
    model.addConstr(x1 + 3 * x2 <= 10, name="muscle_growth_index_upper_bound")
    model.addConstr(3 * x1 + 3 * x2 <= 20, name="immune_support_index_upper_bound")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B3: {x1.varValue}")
        print(f"Grams of fiber: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
