
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x = m.addVars(7, name="hours_worked")

# Set the objective function
m.setObjective(6.63*x[0] + 6.54*x[1] + 2.03*x[2] + 9.2*x[3] + 8.24*x[4] + 9.16*x[5] + 7.76*x[6], gp.GRB.MINIMIZE)

# Add constraints
# Organization score constraints
m.addConstr(x[0] <= 732 / 1)
m.addConstr(3*x[1] <= 732)
m.addConstr(5*x[2] <= 732)
m.addConstr(10*x[3] <= 732)
m.addConstr(7*x[4] <= 732)
m.addConstr(2*x[5] <= 732)
m.addConstr(22*x[6] <= 732)

m.addConstr(21*x[0] + 20*x[1] + 3*x[2] + 15*x[3] + 6*x[4] + 1*x[5] + 1*x[6] <= 282)

m.addConstr(20*x[0] + 7*x[1] + 13*x[2] + 21*x[3] + 2*x[4] + 20*x[5] + 1*x[6] <= 503)

m.addConstr(8*x[0] + 19*x[1] + 1*x[2] + 8*x[3] + 15*x[4] + 15*x[5] + 3*x[6] <= 347)

# Add other constraints...

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    for i in range(7):
        print(f"Hours worked by {['Paul', 'Ringo', 'Dale', 'Hank', 'Bill', 'Jean', 'Peggy'][i]}: {x[i].x}")
else:
    print("No optimal solution found")
