
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x0 = model.addVar(name="x0", lb=0)  # milligrams of vitamin D
    x1 = model.addVar(name="x1", lb=0)  # milligrams of calcium
    x2 = model.addVar(name="x2", lb=0)  # milligrams of vitamin B2

    # Objective function
    model.setObjective(6.46 * x0 * 1.98 * x1 * 6.73 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(23 * x0 + 33 * x2 >= 28)
    model.addConstr(23 * x0 + 34 * x1 >= 51)
    model.addConstr(23 * x0 + 34 * x1 + 33 * x2 >= 51)
    model.addConstr(10 * x0 + 9 * x2 >= 23)
    model.addConstr(10 * x0 + 11 * x1 >= 20)
    model.addConstr(11 * x1 + 9 * x2 >= 40)
    model.addConstr(10 * x0 + 11 * x1 + 9 * x2 >= 46)
    model.addConstr(23 * x0 + 34 * x1 + 33 * x2 <= 168)

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin D: {x0.varValue}")
        print(f"Milligrams of calcium: {x1.varValue}")
        print(f"Milligrams of vitamin B2: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.Status.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_optimization_problem()
