
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    x = m.addVars(5, lb=0.0, names=["B1", "B5", "B3", "B2", "K"])

    # Set objective function
    m.setObjective(2*x[0] + 3*x[1] + 3*x[2] + 5*x[3] + 9*x[4], gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(13*x[0] + 21*x[1] >= 46)
    m.addConstr(23*x[2] + 16*x[3] >= 37)
    m.addConstr(21*x[1] + 16*x[3] >= 33)
    m.addConstr(13*x[0] + 23*x[2] >= 51)
    m.addConstr(21*x[1] + 23*x[2] >= 59)
    m.addConstr(16*x[3] + 9*x[4] >= 33)
    m.addConstr(13*x[0] + 9*x[4] >= 53)
    m.addConstr(13*x[0] + 23*x[2] + 16*x[3] >= 45)
    m.addConstr(13*x[0] + 23*x[2] + 9*x[4] >= 45)
    m.addConstr(21*x[1] + 16*x[3] + 9*x[4] >= 45)
    m.addConstr(21*x[1] + 23*x[2] + 16*x[3] >= 45)
    m.addConstr(13*x[0] + 23*x[2] + 16*x[3] >= 53)
    m.addConstr(13*x[0] + 23*x[2] + 9*x[4] >= 53)
    m.addConstr(21*x[1] + 16*x[3] + 9*x[4] >= 53)
    m.addConstr(21*x[1] + 23*x[2] + 16*x[3] >= 53)
    m.addConstr(13*x[0] + 23*x[2] + 16*x[3] >= 60)
    m.addConstr(13*x[0] + 23*x[2] + 9*x[4] >= 60)
    m.addConstr(21*x[1] + 16*x[3] + 9*x[4] >= 60)
    m.addConstr(21*x[1] + 23*x[2] + 16*x[3] >= 60)
    m.addConstr(13*x[0] + 23*x[2] + 16*x[3] >= 78)
    m.addConstr(13*x[0] + 23*x[2] + 9*x[4] >= 78)
    m.addConstr(21*x[1] + 16*x[3] + 9*x[4] >= 78)
    m.addConstr(21*x[1] + 23*x[2] + 16*x[3] >= 78)
    m.addConstr(8*x[0] - 3*x[1] + 10*x[2] >= 0)
    m.addConstr(21*x[1] + 9*x[4] <= 275)
    m.addConstr(16*x[3] + 9*x[4] <= 144)
    m.addConstr(13*x[0] + 21*x[1] + 9*x[4] <= 197)
    m.addConstr(13*x[0] + 23*x[2] + 9*x[4] <= 265)
    m.addConstr(13*x[0] + 21*x[1] + 23*x[2] + 16*x[3] + 9*x[4] <= 265)
    m.addConstr(13*x[0] + 21*x[1] + 23*x[2] + 16*x[3] + 9*x[4] <= 401)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print(f'{v.varName}: {v.x}')
        print(f'Obj: {m.objVal}')
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
