
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x1")  # milligrams of vitamin B1
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x2")  # milligrams of vitamin B5
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x3")  # milligrams of vitamin B3
    x4 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x4")  # milligrams of vitamin B2
    x5 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x5")  # milligrams of potassium

    # Objective function
    model.setObjective(2 * x1 + 3 * x2 + 3 * x3 + 5 * x4 + 9 * x5, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(13 * x1 + 21 * x2 >= 46)
    model.addConstr(23 * x3 + 16 * x4 >= 37)
    model.addConstr(21 * x2 + 16 * x4 >= 33)
    model.addConstr(13 * x1 + 23 * x3 >= 51)
    model.addConstr(21 * x2 + 23 * x3 >= 59)
    model.addConstr(16 * x4 + 9 * x5 >= 33)
    model.addConstr(13 * x1 + 9 * x5 >= 53)
    model.addConstr(13 * x1 + 23 * x3 + 16 * x4 >= 45)
    model.addConstr(13 * x1 + 23 * x3 + 9 * x5 >= 45)
    model.addConstr(21 * x2 + 16 * x4 + 9 * x5 >= 45)
    model.addConstr(21 * x2 + 23 * x3 + 16 * x4 >= 45)
    model.addConstr(13 * x1 + 23 * x3 + 16 * x4 >= 53)
    model.addConstr(13 * x1 + 23 * x3 + 9 * x5 >= 53)
    model.addConstr(21 * x2 + 16 * x4 + 9 * x5 >= 53)
    model.addConstr(21 * x2 + 23 * x3 + 16 * x4 >= 53)
    model.addConstr(13 * x1 + 23 * x3 + 16 * x4 >= 60)
    model.addConstr(13 * x1 + 23 * x3 + 9 * x5 >= 60)
    model.addConstr(21 * x2 + 16 * x4 + 9 * x5 >= 60)
    model.addConstr(21 * x2 + 23 * x3 + 16 * x4 >= 60)
    model.addConstr(13 * x1 + 23 * x3 + 16 * x4 >= 78)
    model.addConstr(13 * x1 + 23 * x3 + 9 * x5 >= 78)
    model.addConstr(21 * x2 + 16 * x4 + 9 * x5 >= 78)
    model.addConstr(21 * x2 + 23 * x3 + 16 * x4 >= 78)
    model.addConstr(8 * x1 - 3 * x2 + 10 * x3 >= 0)
    model.addConstr(21 * x2 + 9 * x5 <= 275)
    model.addConstr(16 * x4 + 9 * x5 <= 144)
    model.addConstr(13 * x1 + 21 * x2 + 9 * x5 <= 197)
    model.addConstr(13 * x1 + 23 * x3 + 9 * x5 <= 265)
    model.addConstr(13 * x1 + 21 * x2 + 23 * x3 + 16 * x4 + 9 * x5 <= 265)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print("Objective: ", model.objVal)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
        print("x4: ", x4.varValue)
        print("x5: ", x5.varValue)
    else:
        print("No optimal solution found.")

solve_optimization_problem()
