
from gurobipy import Model, GRB

model = Model("Minimize_Hours")

# Define variables
laura = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Laura")
dale = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Dale")
hank = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Hank")
george = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="George")
paul = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Paul")
mary = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Mary")
jean = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Jean")


# Set objective function
model.setObjective(1.04 * laura + 7.65 * dale + 6.09 * hank + 3.37 * george + 7.17 * paul + 2.42 * mary + 2.68 * jean, GRB.MINIMIZE)


# Add constraints - Resource related constraints are added based on the provided data
resource_data = {
    'r0': {'upper_bound': 439, 'x0': 8.22, 'x1': 6.55, 'x2': 1.4, 'x3': 7.69, 'x4': 11.26, 'x5': 4.18, 'x6': 11.57},
    'r1': {'upper_bound': 442, 'x0': 9.07, 'x1': 12.68, 'x2': 12.78, 'x3': 1.74, 'x4': 9.37, 'x5': 7.46, 'x6': 9.53},
    'r2': {'upper_bound': 359, 'x0': 2.82, 'x1': 8.72, 'x2': 3.79, 'x3': 8.52, 'x4': 0.35, 'x5': 7.85, 'x6': 8.83},
    'r3': {'upper_bound': 420, 'x0': 10.7, 'x1': 7.57, 'x2': 6.98, 'x3': 0.12, 'x4': 1.05, 'x5': 12.01, 'x6': 2.85},
    'r4': {'upper_bound': 447, 'x0': 12.33, 'x1': 9.54, 'x2': 7.87, 'x3': 4.1, 'x4': 7.53, 'x5': 8.43, 'x6': 7.98}
}
variables = [laura, dale, hank, george, paul, mary, jean]

# Add constraints from the JSON "constraints" field.
constraints_json = {
  "constraints": [
"1.4 * x2 + 4.18 * x5 >= 62",
# ... (rest of the constraints)
  ]
}

for constraint_str in constraints_json["constraints"]:
    model.addConstr(eval(constraint_str.replace("x0", "laura").replace("x1", "dale").replace("x2", "hank").replace("x3", "george").replace("x4", "paul").replace("x5", "mary").replace("x6", "jean")))


# Optimize the model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print(f"Optimization ended with status {model.status}")

