
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x = m.addVars(7, lb=0, name="hours_worked")

# Set the objective function
m.setObjective(1.04*x[0] + 7.65*x[1] + 6.09*x[2] + 3.37*x[3] + 7.17*x[4] + 2.42*x[5] + 2.68*x[6], gp.GRB.MINIMIZE)

# Organization score constraints
m.addConstr(8.22*x[0] + 6.55*x[1] + 1.4*x[2] + 7.69*x[3] + 11.26*x[4] + 4.18*x[5] + 11.57*x[6] <= 439)

# Work quality rating constraints
m.addConstr(9.07*x[0] + 12.68*x[1] + 12.78*x[2] + 1.74*x[3] + 9.37*x[4] + 7.46*x[5] + 9.53*x[6] <= 442)

# Paperwork competence rating constraints
m.addConstr(2.82*x[0] + 8.72*x[1] + 3.79*x[2] + 8.52*x[3] + 0.35*x[4] + 7.85*x[5] + 8.83*x[6] <= 359)

# Dollar cost per hour constraints
m.addConstr(10.7*x[0] + 7.57*x[1] + 6.98*x[2] + 0.12*x[3] + 1.05*x[4] + 12.01*x[5] + 2.85*x[6] <= 420)

# Computer competence rating constraints
m.addConstr(12.33*x[0] + 9.54*x[1] + 7.87*x[2] + 4.1*x[3] + 7.53*x[4] + 8.43*x[5] + 7.98*x[6] <= 447)

# Combined organization score constraints
m.addConstr(1.4*x[2] + 4.18*x[5] >= 62)
m.addConstr(7.69*x[3] + 8.52*x[2] >= 35)
m.addConstr(7.69*x[3] + 11.26*x[4] >= 55)
m.addConstr(7.69*x[3] + 0.35*x[4] >= 57)
m.addConstr(6.55*x[1] + 11.57*x[6] >= 35)
m.addConstr(8.22*x[0] + 11.26*x[4] >= 34)
m.addConstr(4.18*x[5] + 11.57*x[6] >= 22)
m.addConstr(7.69*x[3] + 0.35*x[4] >= 43)
m.addConstr(8.22*x[0] + 7.69*x[3] >= 35)
m.addConstr(6.55*x[1] + 7.69*x[3] >= 29)
m.addConstr(1.4*x[2] + 6.55*x[1] >= 37)
m.addConstr(8.22*x[0] + 6.55*x[1] >= 38)
m.addConstr(11.26*x[4] + 11.57*x[6] >= 47)
m.addConstr(1.4*x[2] + 11.26*x[4] + 11.57*x[6] >= 43)
m.addConstr(8.22*x[0] + 6.55*x[1] + 1.4*x[2] + 7.69*x[3] + 11.26*x[4] + 4.18*x[5] + 11.57*x[6] >= 43)

# Work quality rating constraints
m.addConstr(12.68*x[1] + 7.46*x[5] >= 43)
m.addConstr(12.68*x[1] + 9.53*x[6] >= 46)
m.addConstr(7.46*x[5] + 9.53*x[6] >= 62)
m.addConstr(9.37*x[4] + 7.46*x[5] >= 44)
m.addConstr(12.68*x[1] + 9.37*x[4] >= 34)
m.addConstr(12.78*x[2] + 7.46*x[5] >= 44)
m.addConstr(9.07*x[0] + 12.68*x[1] >= 59)
m.addConstr(1.74*x[3] + 7.46*x[5] + 9.53*x[6] >= 46)
m.addConstr(1.74*x[3] + 9.37*x[4] + 9.53*x[6] >= 46)
m.addConstr(9.37*x[4] + 7.46*x[5] + 9.53*x[6] >= 46)
m.addConstr(12.78*x[2] + 9.37*x[4] + 7.46*x[5] >= 46)
m.addConstr(12.78*x[2] + 9.37*x[4] + 9.53*x[6] >= 46)
m.addConstr(12.78*x[2] + 7.46*x[5] + 9.53*x[6] >= 46)
m.addConstr(12.68*x[1] + 12.78*x[2] + 9.37*x[4] >= 46)
m.addConstr(12.78*x[2] + 9.37*x[4] + 7.46*x[5] >= 46)
m.addConstr(9.07*x[0] + 9.37*x[4] + 7.46*x[5] >= 46)
m.addConstr(12.78*x[2] + 7.46*x[5] + 9.53*x[6] >= 50)
m.addConstr(1.74*x[3] + 7.46*x[5] + 9.53*x[6] >= 50)
m.addConstr(9.37*x[4] + 7.46*x[5] + 9.53*x[6] >= 50)
m.addConstr(12.78*x[2] + 7.46*x[5] + 9.53*x[6] >= 50)
m.addConstr(12.68*x[1] + 12.78*x[2] + 9.37*x[4] >= 50)
m.addConstr(12.78*x[2] + 9.37*x[4] + 7.46*x[5] >= 50)
m.addConstr(12.68*x[1] + 9.37*x[4] + 7.46*x[5] >= 50)
m.addConstr(12.68*x[1] + 9.37*x[4] + 9.53*x[6] >= 50)
m.addConstr(1.74*x[3] + 9.37*x[4] + 9.53*x[6] >= 50)
m.addConstr(9.07*x[0] + 9.37*x[4] + 7.46*x[5] >= 50)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    for i in range(7):
        print(f"Hours worked by person {i}: {x[i].x}")
else:
    print("No solution found")
