
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
potatoes = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="potatoes")
apple_pies = m.addVar(lb=0, vtype=GRB.INTEGER, name="apple_pies")
kale_salads = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="kale_salads")


# Set objective function
m.setObjective(2.08*potatoes**2 + 2.07*apple_pies**2 + 9.38*apple_pies*kale_salads, GRB.MAXIMIZE)

# Add constraints
m.addConstr(13.7*apple_pies + 11.67*kale_salads <= 50, "c1")
m.addConstr(2.54*potatoes**2 + 11.67*kale_salads**2 <= 115, "c2")
m.addConstr(2.54*potatoes + 13.7*apple_pies + 11.67*kale_salads <= 115, "c3")



# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('potatoes:', potatoes.x)
    print('apple_pies:', apple_pies.x)
    print('kale_salads:', kale_salads.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

