
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x1 = m.addVar(lb=0, name="potatoes", vtype=GRB.CONTINUOUS)
x2 = m.addVar(lb=0, name="apple_pies", vtype=GRB.INTEGER)
x3 = m.addVar(lb=0, name="kale_salads", vtype=GRB.CONTINUOUS)

# Set the objective function
m.setObjective(2.08*x1**2 + 2.07*x2**2 + 9.38*x2*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2.54*x1 + 13.7*x2 + 11.67*x3 <= 115, name="total_calcium")
m.addConstr(13.7*x2 + 11.67*x3 <= 50, name="calcium_from_pies_and_salads")
m.addConstr(2.54*x1**2 + 11.67*x3**2 <= 115, name="calcium_from_potatoes_and_salads_squared")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Potatoes: {x1.x}")
    print(f"Apple Pies: {x2.x}")
    print(f"Kale Salads: {x3.x}")
else:
    print("No optimal solution found")
