
import gurobi

def optimize_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="potatoes")  # non-negative real
    x2 = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="apple_pies")  # non-negative integer
    x3 = model.addVar(lb=0, name="kale_salads")  # non-negative real

    # Define the objective function
    model.setObjective(2.08*x1**2 + 2.07*x2**2 + 9.38*x2*x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(13.7*x2 + 11.67*x3 <= 50)
    model.addConstr(2.54*x1**2 + 11.67*x3**2 <= 115)
    model.addConstr(2.54*x1 + 13.7*x2 + 11.67*x3 <= 126) # corrected upper bound

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Potatoes: {x1.varValue}")
        print(f"Apple pies: {x2.varValue}")
        print(f"Kale salads: {x3.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
