
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hours worked by Jean")
    x1 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hours worked by Mary")


    # Set objective function
    model.setObjective(5.11 * x0 + 6.35 * x1, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(5 * x0 + 1 * x1 >= 19, "c0")
    model.addConstr(12 * x0 + 4 * x1 >= 18, "c1")
    model.addConstr(10 * x0 + 7 * x1 >= 21, "c2")
    model.addConstr(12 * x0 + 14 * x1 >= 10, "c3")
    model.addConstr(8 * x0 - 1 * x1 >= 0, "c4")
    model.addConstr(5 * x0 + 1 * x1 <= 34, "c5")
    model.addConstr(12 * x0 + 4 * x1 <= 31, "c6")
    model.addConstr(10 * x0 + 7 * x1 <= 52, "c7")
    model.addConstr(12 * x0 + 14 * x1 <= 42, "c8")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"hours worked by Jean: {x0.x}")
        print(f"hours worked by Mary: {x1.x}")
        print(f"Objective Value: {model.objVal}")

except gp.GurobiError as e:
    print(f"Gurobi Error: {e}")

except AttributeError:
    print("Encountered an attribute error")
