
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(name='hours_worked_by_Jean', lb=0)
x1 = m.addVar(name='hours_worked_by_Mary', lb=0)

# Objective function: Minimize 5.11*x0 + 6.35*x1
m.setObjective(5.11*x0 + 6.35*x1, GRB.MINIMIZE)

# Constraints
m.addConstr(5*x0 + x1 >= 19, name='organization_score_constraint')
m.addConstr(12*x0 + 4*x1 >= 18, name='dollar_cost_per_hour_constraint')
m.addConstr(10*x0 + 7*x1 >= 21, name='computer_competence_rating_constraint')
m.addConstr(12*x0 + 14*x1 >= 10, name='paperwork_competence_rating_constraint')
m.addConstr(8*x0 - x1 >= 0, name='additional_linear_constraint')
m.addConstr(5*x0 + x1 <= 34, name='upper_bound_organization_score')
m.addConstr(12*x0 + 4*x1 <= 31, name='upper_bound_dollar_cost_per_hour')
m.addConstr(10*x0 + 7*x1 <= 52, name='upper_bound_computer_competence_rating')
m.addConstr(12*x0 + 14*x1 <= 42, name='upper_bound_paperwork_competence_rating')

# Optimize
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Jean: {x0.x}")
    print(f"Hours worked by Mary: {x1.x}")
else:
    print("No optimal solution found")
